/**
 * FreeRDP: A Remote Desktop Protocol Implementation
 * MacFreeRDP
 *
 * Copyright 2012 Thomas Goddard
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#import <Cocoa/Cocoa.h>

#import "mfreerdp.h"
#import "mf_client.h"
#import "Keyboard.h"
#import "MRDPCursor.h"

#import "MRDPViewDelegate.h"

@interface MRDPView : NSView<MRDPClientDelegate>
{
	NSMutableArray* windows;
	NSCursor* currentCursor;
	freerdp* instance;
	rdpContext* context;
	CGContextRef bitmap_context;
	BOOL initialized;
	
@public
	NSObject<MRDPViewDelegate> *delegate;
}

- (void)setCursor:(MRDPCursor*) cursor;
- (void)releaseResources;
- (void)preConnect:(freerdp*)rdpInstance;
- (bool)postConnect:(freerdp*)rdpInstance;
- (void)willResizeDesktop;
- (BOOL)didResizeDesktop;
- (BOOL)provideServerCredentials:(ServerCredential **)credentials;
- (BOOL)validateCertificate:(ServerCertificate *)certificate;
- (BOOL)validateX509Certificate:(X509Certificate *)certificate;

@property(nonatomic, assign) NSObject<MRDPViewDelegate> *delegate;

@end
